# 機能設計書 36-ValidatingAdmissionPolicy Statusコントローラー

## 概要

本ドキュメントは、Kubernetes kube-controller-managerに含まれるValidatingAdmissionPolicy Statusコントローラーの機能設計を記述する。ValidatingAdmissionPolicyリソースのStatus.TypeCheckingフィールドを更新し、CEL式の型チェック結果を記録する。

### 本機能の処理概要

**業務上の目的・背景**：ValidatingAdmissionPolicyはKubernetes 1.30でGAとなった機能であり、CEL（Common Expression Language）式を使用してAdmission制御ルールを定義できる。本コントローラーは、ポリシー定義内のCEL式に対する静的型チェックを実行し、型エラーの警告をStatusフィールドに記録する。これにより、管理者はポリシーを適用する前に潜在的な型エラーを検出できる。

**機能の利用シーン**：ValidatingAdmissionPolicyリソースの作成・更新時に自動的に動作し、CEL式の型チェック結果をStatusに反映する。

**主要な処理内容**：
1. ValidatingAdmissionPolicyリソースの作成・更新を監視する
2. ポリシーのGeneration > Status.ObservedGenerationの場合のみ処理を実行する（変更検出）
3. TypeCheckerを使用してCEL式の型チェックを実行する
4. 型チェック結果（ExpressionWarnings）をStatus.TypeCheckingフィールドに記録する
5. ObservedGenerationを更新して処理済みを示す

**関連システム・外部連携**：API Server Admission Plugin、CELランタイム、TypeChecker

**権限による制御**：ValidatingAdmissionPolicyのGet、List、Watch、ApplyStatus権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | kubectl get validatingadmissionpolicies | 参照画面 | ポリシーと型チェック結果の確認 |

## 機能種別

ステータス更新 / 静的解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ValidatingAdmissionPolicy | v1.ValidatingAdmissionPolicy | Yes | ポリシーリソース | Generationが有効であること |
| workers | int | Yes | 並列ワーカー数 | 正の整数 |

### 入力データソース

- ValidatingAdmissionPolicy Informer: ポリシーの作成・更新イベント

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Status.ObservedGeneration | int64 | 処理済みGeneration |
| Status.TypeChecking.ExpressionWarnings | []ExpressionWarning | CEL式の型チェック警告リスト |

### 出力先

- Kubernetes API Server（ValidatingAdmissionPolicyのStatus ApplyStatus）

## 処理フロー

### 処理シーケンス

```
1. ValidatingAdmissionPolicy作成・更新イベント受信
   └─ enqueuePolicy()でキューに追加
2. ワーカーがキューからキーを取得
3. processNextWorkItem()
   └─ Lister.Get()でポリシーを取得
   └─ reconcile()を呼び出し
4. reconcile()
   └─ Generation <= ObservedGeneration → スキップ
   └─ typeChecker.Check(policy) で型チェック実行
   └─ ExpressionWarningリストを構築
   └─ ApplyStatus()でStatusを更新
```

### フローチャート

```mermaid
flowchart TD
    A[Policy変更イベント] --> B[キューに追加]
    B --> C[キューからデキュー]
    C --> D{Policy存在?}
    D -->|No| E[スキップ]
    D -->|Yes| F{Generation > ObservedGeneration?}
    F -->|No| G[スキップ - 既に処理済み]
    F -->|Yes| H[typeChecker.Check実行]
    H --> I[ExpressionWarnings構築]
    I --> J[ApplyStatus更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-01 | Generation検出 | Generation > ObservedGenerationの場合のみ型チェックを実行する | reconcile時 |
| BR-36-02 | 型チェック | TypeCheckerでCEL式のParamsKindとMatchingConstraintsに基づく型チェックを行う | reconcile時 |
| BR-36-03 | Server-Side Apply | ApplyStatusでFieldManager=validatingadmissionpolicy-status、Force=trueを使用する | Status更新時 |
| BR-36-04 | クラスタースコープ | ValidatingAdmissionPolicyはクラスタースコープであり、キーは名前のみ | enqueue時 |

### 計算ロジック

- スキップ判定: `policy.Generation <= policy.Status.ObservedGeneration` の場合はスキップ
- 型チェック: `typeChecker.Check(policy)` で `[]ExpressionWarning{FieldRef, Warning}` を返す

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Status更新 | ValidatingAdmissionPolicy | APPLY (Status) | TypeChecking, ObservedGenerationの更新 |

### テーブル別操作詳細

#### ValidatingAdmissionPolicy

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| ApplyStatus | status.observedGeneration | policy.Generation | Server-Side Apply |
| ApplyStatus | status.typeChecking.expressionWarnings | 型チェック結果 | FieldRef + Warning |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotFound | ポリシー不在 | ポリシーが削除されている | 正常終了扱い |
| - | ApplyStatus失敗 | API Server通信エラー | レートリミット付きリトライ |

### リトライ仕様

- ワークキューのデフォルトレートリミッタによるリトライ

## トランザクション仕様

Server-Side Apply（Force=true）による原子的なStatus更新。

## パフォーマンス要件

- ワーカーループ周期: 1秒
- Generation比較によるスキップで不要な型チェックを回避

## セキュリティ考慮事項

- 型チェックは読み取り専用の静的解析であり、副作用はない
- ApplyStatusにはForce=trueを使用し、他のFieldManagerとの競合を回避

## 備考

- コントローラー名は`validatingadmissionpolicy-status`であり、API Server内で動作するValidatingAdmissionPolicyコントローラーとは別物
- ValidatingAdmissionPolicyはKubernetes 1.30でGA

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | controller.go | `pkg/controller/validatingadmissionpolicystatus/controller.go` | Controller構造体（43-53行目）のフィールド |

**読解のコツ**: Controller構造体は小さく、policyInformer、policyQueue、policySynced、policyClient、typeCheckerの5フィールドのみ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | controller.go | `pkg/controller/validatingadmissionpolicystatus/controller.go` | NewController関数（76-99行目） |

**主要処理**:
- **79-82行目**: キュー作成（Name: validatingadmissionpolicy-status）
- **86-93行目**: AddEventHandlerでAdd/Update時にenqueuePolicy呼び出し
- **97行目**: reg.HasSyncedをpolicySyncedに設定

#### Step 3: reconcile処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | controller.go | `pkg/controller/validatingadmissionpolicystatus/controller.go` | reconcile関数（147-168行目） |

**主要処理**:
- **151行目**: Generation <= ObservedGenerationのスキップ判定
- **154行目**: typeChecker.Check(policy)で型チェック実行
- **155-165行目**: ExpressionWarningリストの構築
- **166行目**: ApplyStatusでStatus更新

### プログラム呼び出し階層図

```
NewController (76行目)
    └─ AddEventHandler → enqueuePolicy (101行目)

Run (55行目)
    └─ runWorker (112行目)
        └─ processNextWorkItem (117行目)
            └─ Lister.Get (125行目)
            └─ reconcile (147行目)
                ├─ Generation比較 (151行目)
                ├─ typeChecker.Check (154行目)
                ├─ ExpressionWarning構築 (155-165行目)
                └─ ApplyStatus (166行目)
```

### データフロー図

```
[入力]                              [処理]                    [出力]

ValidatingAdmissionPolicy  ──▶  enqueuePolicy  ──▶          Status更新
  作成・更新イベント              │                          │
                            policyQueue                  ObservedGeneration
                                │                          │
                            processNextWorkItem          TypeChecking
                                │                        .ExpressionWarnings
                            reconcile
                              ├─ typeChecker.Check
                              └─ ApplyStatus
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| controller.go | `pkg/controller/validatingadmissionpolicystatus/controller.go` | ソース | コントローラー本体 |
| TypeChecker | `k8s.io/apiserver/pkg/admission/plugin/policy/validating/typechecking.go` | 外部ライブラリ | CEL式型チェッカー |
